/*
 * Smartcrypt - a tool to encrypt / decrypt files
 * Copyright (C) 2005 Kai Witte
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * For contact information see http://kwitte.dyndns.org/~kwitte/
 */
package org.dyndns.kwitte.smartcrypt.ui.controller;

import javax.swing.text.JTextComponent;
import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;

/**
 * A <code>FocusListener</code> for <code>JTextComponent</code>s to select
 * all text when focus is gained.
 */ 
public class SelectAllListener implements FocusListener {
    /**
     * Selects all text in the focused text component.
     * @param e the associated <code>FocusEvent</code>
     * @throws IllegalArgumentException if the corresponding source
     * is not an instance of <code>JTextComponent</code>.
     */
    public void focusGained(FocusEvent e) {
        if (e.getSource() instanceof JTextComponent) {
            ((JTextComponent) e.getSource()).selectAll();
        }
        else {
            throw new IllegalArgumentException(
                "event source must be javax.swing.JTextComponent"
                + "or javax.swing.JComboBox");
        }
    }

    /**
     * Does nothing.
     * @param e the associated <code>FocusEvent</code>
     */
    public void focusLost(FocusEvent e) {}

}
