package org.dyndns.kwitte.smartcrypt.ui;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.Observer;
import java.util.Observable;
import java.util.ResourceBundle;

/**
 * Displays a simple progress dialog.
 * The only option for the user is to cancel and exit the program.
 * All methods must be called in the EDT, and instances must be created in the
 * EDT.
 */
public class ProgressDialog extends JDialog implements Observer {
    private JProgressBar progressBar;
    private static final int MAX_PROGRESS = 100;
    private static final int MIN_PROGRESS = 0;
    private boolean inditerminate;

    /**
     * Creates an instance of a ProgressDialog.
     * @param owner the owner of this Dialog. May be null.
     * @see javax.swing.JDialog#JDialog(Frame)
     */
    public ProgressDialog(Frame owner) {
        super(owner, "stand by ...");
        setModal(true);
        arrangeComponents();
    }

    /**
     * Creates an instance of a ProgressDialog.
     * @param owner the owner of this Dialog. May be null.
     */
    public ProgressDialog(Dialog owner) {
        super(owner, "stand by ...");
        setModal(true);
        arrangeComponents();
    }

    /**
     * Creates an instance of a ProgressDialog.
     * @param owner the owner of this Dialog. May be null.
     * @see javax.swing.JDialog#JDialog(Frame)
     */
    public ProgressDialog(Frame owner, String msg) {
        super(owner, msg);
        setModal(true);
        arrangeComponents();
    }

    /**
     * Creates an instance of a ProgressDialog.
     * @param owner the owner of this Dialog. May be null.
     * @param msg the message to be displayed in the title bar
     */
    public ProgressDialog(Dialog owner, String msg) {
        super(owner, msg);
        setModal(true);
        arrangeComponents();
    }

    private void arrangeComponents() {
        getContentPane().setLayout(new BorderLayout());

        JButton cancelButton = new JButton("Cancel and exit");
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
                System.exit(1);
            }
        });

        progressBar = new JProgressBar();
        progressBar.setStringPainted(true);
        progressBar.setString("");

        getContentPane().add(cancelButton, BorderLayout.PAGE_END);
        getContentPane().add(progressBar, BorderLayout.CENTER);

        setResizable(false);
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        pack();
    }

    /**
     * Shows a ProgressDialog.
     * @param s description of the process to wait for (shown in progress bar)
     * <br>may be null
     */
    public void showProgress(String s) {
        progressBar.setString(s);
        progressBar.setIndeterminate(inditerminate);
        setVisible(true);
    }

    public void update(Observable o, Object arg) {
        if (!(arg instanceof Integer)) {
            throw new IllegalArgumentException(
                "expected instance of integer, found " + arg.getClass());
        }

        int value = ((Integer) arg).intValue();
        if (value < MIN_PROGRESS || value > MAX_PROGRESS) {
            throw new IndexOutOfBoundsException(
                "illegal value: " + value
                + " - must be < " + MAX_PROGRESS
                + " and > " + MIN_PROGRESS
            );
        }

        progressBar.setValue(value);
    }

    public void setInditerminate(boolean inditerminate) {
        this.inditerminate = inditerminate;
    }
}

