/*
 * Smartcrypt - a tool to encrypt / decrypt files
 * Copyright (C) 2005 Kai Witte
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * For contact information see http://kwitte.dyndns.org/~kwitte/
 */


package org.dyndns.kwitte.smartcrypt;

import javax.crypto.*;
import java.security.*;
import javax.crypto.spec.*;
import java.security.spec.*;

public class KeyFactoryImpl implements KeyFactory {

    public Key createKey(String algorithm, String password)
            throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeyFactory pfac = 
            SecretKeyFactory.getInstance(algorithm);
        try {
            return pfac.generateSecret(new PBEKeySpec(password.toCharArray()));
        } catch (InvalidKeySpecException i) {
            throw new NoSuchAlgorithmException(i.getMessage());
        }
    }
}
