/*
 * Smartcrypt - a tool to encrypt / decrypt files
 * Copyright (C) 2005 Kai Witte
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * For contact information see http://kwitte.dyndns.org/~kwitte/
 */


package org.dyndns.kwitte.smartcrypt;

import javax.crypto.Cipher;
import java.io.IOException;
import java.io.File;
import java.io.OutputStream;
import java.util.Observable;

/**
 * A class that filters a file through a cipher stream.
 */
public abstract class FileManager extends Observable {

    /**
     * Filters the <code>infile</code> through the given <code>Cipher</code>s
     * using a <code>javax.crypto.CipherInputStream</code>
     * and a <code>javax.crypto.CipherOutputStream</code>.
     * @param infile source file
     * @param outfile destination file (will be created or replaced)
     * @param in the cipher to be used when reading the file
     * @throws IOException if an input/output error occurs
     * @throws NullPointerException iff
     * <code>infile == null || outfile == null || in == null || out == null
     * </code>
     */
    public abstract void filterFile(File infile, OutputStream outfile, Cipher in)
        throws IOException;
    
    /**
     * Changes the size of the files.
     * @param totalFileSize the sum of the size of all files, 
     * used for progress calculation
     */ 
    public abstract void setTotalSize(long totalFileSize);
}

