package org.dyndns.kwitte.smartcrypt;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;

public class FileListImpl implements FileList {
    public File[] listFiles(File sourcedir, FileFilter filter) {
        if (!(sourcedir.exists() && sourcedir.isDirectory())) {
            return new File[] {sourcedir};
//            throw new IllegalArgumentException(
//                "sourcedir must exist and be a directory"
//            );
        };

        List<File> ret = new ArrayList<File>();
        File[] list = sourcedir.listFiles();

        if (list == null) {
            // unreadable directory, e. g. "System Volume Information" on Win2k
            return new File[0];
        }

        for (File file : list) {
            if (file.isDirectory()) {
                ret.addAll(Arrays.asList(listFiles(file, filter)));
            }
            if (filter != null && !filter.accept(file)) {
                continue;
            }
            ret.add(file);
        }

        return ret.toArray(new File[0]);
    }
}
