/*
 * Smartcrypt - a tool to encrypt / decrypt files
 * Copyright (C) 2005 Kai Witte
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * For contact information see http://kwitte.dyndns.org/~kwitte/
 */


package org.dyndns.kwitte.smartcrypt;

import javax.crypto.*;
import java.security.*;
import java.security.spec.*;
import javax.crypto.spec.PBEParameterSpec;

public class CipherFactoryImpl implements CipherFactory {
    /**
     * The salt used for the encryption:
     * 3 4 27 9 4 9 27 100
     */
    public static final byte[] salt = new byte[] { 3, 4, 27, 9, 4, 9, 27, 100 };

    public Cipher createCipher(String algorithm, String password, int mode)
            throws NoSuchAlgorithmException, InvalidKeyException {
        if (algorithm == null || password == null) {
            throw new NullPointerException();
        }
        if (mode != Cipher.ENCRYPT_MODE && mode != Cipher.DECRYPT_MODE) {
            throw new IllegalArgumentException();
        }
        KeyFactory kf = new KeyFactoryImpl();
        Key key = kf.createKey(algorithm, password);

        PBEParameterSpec pspec = new PBEParameterSpec(salt, 1024);
        AlgorithmParameters params = AlgorithmParameters.getInstance("PBE");
        try {
            params.init(pspec);
        } catch (InvalidParameterSpecException i) {
            // can't happen, pspec is constant
            throw new AssertionError();
        }

        Cipher c;
        try {
            c = Cipher.getInstance(algorithm);
        } catch (NoSuchPaddingException nspe) {
            throw new NoSuchAlgorithmException(nspe.getMessage());
        }
        try {
            c.init(mode, key, params);
        } catch (InvalidAlgorithmParameterException i) {
            // can't happen, params is constant
            throw new AssertionError();
        }
        return c;
    }
}
