/*
 * Smartcrypt - a tool to encrypt / decrypt files
 * Copyright (C) 2005 Kai Witte
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * For contact information see http://kwitte.dyndns.org/~kwitte/
 */


package org.dyndns.kwitte.smartcrypt;

import javax.crypto.*;
import java.security.*;

/**
 * A factory to create <code>javax.crypto.Cipher</code>s.
 */
public interface CipherFactory {
    /**
     * Creates a <code>Cipher</code>.
     * @param algorithm algorithm to be used. Must be compatible with a
     * password based encryption, for example PBEWithMD5AndDES.
     * @param password a passphase for the encryption
     * @param mode Cipher.ENCRYPT_MODE or Cipher.DECRYPT_MODE
     * @return a new <code>Cipher</code>.
     * @throws NoSuchAlgorithmException if the algorithm is not supported by
     * the installed providers
     * @throws InvalidKeyException if the passphrase is incompatible to the
     * specified algorithm
     * @throws NullPointerException if <code>algorithm == null || password ==
     * null</code>
     * @throws IllegalArgumentException if the <code>mode</code> is not
     * supported by the implementation
     */
    public Cipher createCipher(String algorithm, String password, int mode)
        throws NoSuchAlgorithmException, InvalidKeyException;
}
