/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.kwitte.smartcrypt.ui.controller;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public abstract class DropFileHandler
extends TransferHandler {
    private TransferHandler wrappedHandler;

    protected DropFileHandler() {
    }

    protected DropFileHandler(TransferHandler transferHandler) {
        this.wrappedHandler = transferHandler;
    }

    public abstract void dropFiles(File[] var1);

    public boolean importData(JComponent jComponent, Transferable transferable) {
        boolean bl = false;
        try {
            File[] fileArray = this.grepFiles(transferable);
            if (fileArray != null) {
                this.dropFiles(fileArray);
                bl = true;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            throw new AssertionError((Object)unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Logger.getLogger("org.dyndns.kwitte.smartcrypt.ui.controller").throwing("DropFileHandler", "importData", iOException);
        }
        return super.importData(jComponent, transferable) | (this.wrappedHandler != null && this.wrappedHandler.importData(jComponent, transferable)) | bl;
    }

    private File[] grepFiles(Transferable transferable) throws UnsupportedFlavorException, IOException {
        for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
            if (!dataFlavor.equals(DataFlavor.javaFileListFlavor)) continue;
            return ((List)transferable.getTransferData(dataFlavor)).toArray(new File[0]);
        }
        return null;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return Arrays.asList(dataFlavorArray).contains(DataFlavor.javaFileListFlavor) || this.wrappedHandler != null && this.wrappedHandler.canImport(jComponent, dataFlavorArray) || super.canImport(jComponent, dataFlavorArray);
    }

    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        super.exportAsDrag(jComponent, inputEvent, n);
        if (this.wrappedHandler != null) {
            this.wrappedHandler.exportAsDrag(jComponent, inputEvent, n);
        }
    }

    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) throws IllegalStateException {
        super.exportToClipboard(jComponent, clipboard, n);
        if (this.wrappedHandler != null) {
            this.wrappedHandler.exportToClipboard(jComponent, clipboard, n);
        }
    }

    public int getSourceActions(JComponent jComponent) {
        int n = super.getSourceActions(jComponent);
        if (n == 0 && this.wrappedHandler != null) {
            n = this.wrappedHandler.getSourceActions(jComponent);
        }
        return n;
    }

    public Icon getVisualRepresentation(Transferable transferable) {
        Icon icon = super.getVisualRepresentation(transferable);
        if (icon == null && this.wrappedHandler != null) {
            icon = this.wrappedHandler.getVisualRepresentation(transferable);
        }
        return icon;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        return super.createTransferable(jComponent);
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        super.exportDone(jComponent, transferable, n);
    }
}

