/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.kwitte.smartcrypt.ui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.dyndns.kwitte.smartcrypt.ui.MainModel;
import org.dyndns.kwitte.smartcrypt.ui.controller.DecryptAction;
import org.dyndns.kwitte.smartcrypt.ui.controller.DropFileHandler;
import org.dyndns.kwitte.smartcrypt.ui.controller.EncryptAction;
import org.dyndns.kwitte.smartcrypt.ui.controller.SelectAllListener;
import org.dyndns.kwitte.smartcrypt.ui.controller.SelectInfileAction;
import org.dyndns.kwitte.smartcrypt.ui.controller.SelectOutfileAction;

public final class MainView
extends JFrame {
    private static final String VERSION = "3.5";
    private static final MainView INSTANCE = new MainView();
    private static final String DEFAULT_ALGORITHM = "PBEWITHSHA256AND256BITAES-CBC-BC";
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org/dyndns/kwitte/smartcrypt/ui/mainview");
    private JPasswordField passwordField1;
    private JPasswordField passwordField2;
    private JComboBox algorithmComboBox;
    private JButton sourceButton;
    private JPanel panel;
    private JButton outputButton;
    private JButton encryptButton;
    private JButton decryptButton;
    private JTextField sourceFileName;
    private JTextField outputFileName_;
    private Action infileAction = new SelectInfileAction();
    private Action outfileAction = new SelectOutfileAction();
    private Action encryptAction = new EncryptAction();
    private Action decryptAction = new DecryptAction();
    private JPanel inputFilePanel;
    private JComboBox outputFileName;
    private String[] targetDirectories = new String[]{System.getProperty("user.home"), System.getProperty("user.home") + System.getProperty("file.separator") + ".tiger", new File(".").getAbsoluteFile().toString()};
    private static final int TOOLTIP_DELAY = 15000;
    private JRadioButton radioButtonFile;
    private JRadioButton radioButton1;
    private JRadioButton radioButtonStdout;
    private JComboBox threadPriority;
    private boolean cryptographyExtensionInstalled;

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!this.cryptographyExtensionInstalled) {
            this.error(this.resourceBundle.getString("NO_CRYPTOGRAPHY_EXTENSION_INSTALLED"));
        }
    }

    private MainView() {
        super("TigerCrypt version 3.5");
        this.$$$setupUI$$$();
        this.registerListeners();
        super.setDefaultCloseOperation(3);
        super.setContentPane(this.panel);
        super.setSize(400, 400);
        super.pack();
    }

    private void registerListeners() {
        int n;
        this.sourceButton.setAction(this.infileAction);
        this.outputButton.setAction(this.outfileAction);
        this.encryptButton.setAction(this.encryptAction);
        this.encryptButton.setMnemonic(this.resourceBundle.getString("ENCRYPT_BUTTON_MNEMONIC").charAt(0));
        this.decryptButton.setAction(this.decryptAction);
        this.decryptButton.setMnemonic(this.resourceBundle.getString("DECRYPT_BUTTON_MNEMONIC").charAt(0));
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                MainView.this.fileChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MainView.this.fileChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.sourceFileName.addFocusListener(new SelectAllListener());
        this.outputFileName.getEditor().getEditorComponent().addFocusListener(new SelectAllListener());
        this.passwordField1.addFocusListener(new SelectAllListener());
        this.passwordField2.addFocusListener(new SelectAllListener());
        this.algorithmComboBox.getEditor().getEditorComponent().addFocusListener(new SelectAllListener());
        this.sourceFileName.getDocument().addDocumentListener(documentListener);
        this.outputFileName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MainView.this.fileChanged();
            }
        });
        for (String string : this.targetDirectories) {
            this.outputFileName.addItem(string);
        }
        String[] stringArray = this.supportedAlgorithms();
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String string;
            string = stringArray[n];
            this.algorithmComboBox.addItem(string);
        }
        this.algorithmComboBox.setSelectedItem(DEFAULT_ALGORITHM);
        this.inputFilePanel.setTransferHandler(new DropFileHandler(){

            public void dropFiles(File[] fileArray) {
                if (fileArray.length != 0) {
                    MainView.this.setInfile(fileArray[0]);
                }
            }
        });
        this.sourceFileName.setTransferHandler(new DropFileHandler(this.sourceFileName.getTransferHandler()){

            public void dropFiles(File[] fileArray) {
                if (fileArray.length != 0) {
                    MainView.this.setInfile(fileArray[0]);
                }
            }
        });
        String string = MessageFormat.format(this.resourceBundle.getString("FILE_PANEL_TOOLTIP"), MainView.class.getResource("/res/Open16.gif").toString());
        ToolTipManager.sharedInstance().setDismissDelay(15000);
        this.inputFilePanel.setToolTipText(string);
        this.sourceFileName.setToolTipText(string);
        this.sourceButton.setToolTipText(string);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioButtonFile);
        buttonGroup.add(this.radioButtonStdout);
        this.radioButtonFile.setMnemonic(this.resourceBundle.getString("OUTPUT_FILE_MNEMONIC").charAt(0));
        this.radioButtonStdout.setMnemonic(this.resourceBundle.getString("OUTPUT_STDOUT_MNEMONIC").charAt(0));
        for (n = 1; n <= 10; ++n) {
            this.threadPriority.addItem(n);
        }
        this.threadPriority.setSelectedItem(1);
    }

    public int getThreadPriority() {
        return (Integer)this.threadPriority.getSelectedItem();
    }

    public boolean cryptToStdout() {
        return this.radioButtonStdout.isSelected();
    }

    public static MainView getInstance() {
        return INSTANCE;
    }

    public String getString(String string) {
        return this.resourceBundle.getString(string);
    }

    private void fileChanged() {
        boolean bl = this.sourceFileName.getText().length() != 0;
        this.encryptAction.setEnabled(bl);
        this.decryptAction.setEnabled(bl);
    }

    public void setInfile(File file) {
        this.sourceFileName.setText(file.toString());
    }

    public void setOutfile(File file) {
        this.outputFileName.addItem(file.toString());
        this.outputFileName.setSelectedItem(file.toString());
        this.encryptAction.setEnabled(this.sourceFileName.getText().length() != 0);
        this.decryptAction.setEnabled(this.sourceFileName.getText().length() != 0);
    }

    public String getAlgorithm() {
        return (String)this.algorithmComboBox.getSelectedItem();
    }

    public String getInfile() {
        return this.sourceFileName.getText();
    }

    public String getOutfile() {
        return (String)this.outputFileName.getSelectedItem();
    }

    public char[] getPassword() {
        return this.passwordField1.getPassword();
    }

    public char[] getPasswordConfirm() {
        return this.passwordField2.getPassword();
    }

    private String[] supportedAlgorithms() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            byte[] byArray = new byte[]{3, 4, 27, 9, 4, 9, 27, 100};
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndTripleDES");
            SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec("asdfasdf".toCharArray()));
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, 1024);
            AlgorithmParameters algorithmParameters = null;
            algorithmParameters = AlgorithmParameters.getInstance("PBE");
            algorithmParameters.init(pBEParameterSpec);
            Cipher cipher = Cipher.getInstance("PBEWithMD5AndTripleDES");
            cipher.init(1, (Key)secretKey, algorithmParameters);
            arrayList.add("PBEWithMD5AndTripleDES");
            this.cryptographyExtensionInstalled = true;
        }
        catch (InvalidKeyException invalidKeyException) {
            Logger.getLogger("org.dyndns.kwitte.smartcrypt").throwing("MainView", "supportedAlgorithms", invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.getLogger("org.dyndns.kwitte.smartcrypt").throwing("MainView", "supportedAlgorithms", noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new AssertionError((Object)invalidAlgorithmParameterException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new AssertionError((Object)invalidKeySpecException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new AssertionError((Object)invalidParameterSpecException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new AssertionError((Object)noSuchPaddingException);
        }
        arrayList.add("PBEWITHMD5AND128BITAES-CBC-OPENSSL");
        arrayList.add("PBEWITHMD5AND192BITAES-CBC-OPENSSL");
        arrayList.add("PBEWITHMD5AND256BITAES-CBC-OPENSSL");
        arrayList.add("PBEWITHMD5ANDDES");
        arrayList.add("PBEWITHMD5ANDRC2");
        arrayList.add("PBEWITHSHA-1AND128BITAES-CBC-BC");
        arrayList.add("PBEWITHSHA-1AND192BITAES-CBC-BC");
        arrayList.add("PBEWITHSHA-1AND256BITAES-CBC-BC");
        arrayList.add("PBEWITHSHA-256AND128BITAES-CBC-BC");
        arrayList.add("PBEWITHSHA-256AND192BITAES-CBC-BC");
        arrayList.add("PBEWITHSHA-256AND256BITAES-CBC-BC");
        arrayList.add("PBEWITHSHA1AND128BITAES-CBC-BC");
        arrayList.add("PBEWITHSHA1AND192BITAES-CBC-BC");
        arrayList.add("PBEWITHSHA1AND256BITAES-CBC-BC");
        arrayList.add("PBEWITHSHA1ANDDESEDE");
        arrayList.add("PBEWITHSHA1ANDRC2");
        arrayList.add("PBEWITHSHA256AND128BITAES-CBC-BC");
        arrayList.add("PBEWITHSHA256AND192BITAES-CBC-BC");
        arrayList.add(DEFAULT_ALGORITHM);
        arrayList.add("PBEWITHSHAAND128BITAES-CBC-BC");
        arrayList.add("PBEWITHSHAAND128BITRC2-CBC");
        arrayList.add("PBEWITHSHAAND128BITRC4");
        arrayList.add("PBEWITHSHAAND192BITAES-CBC-BC");
        arrayList.add("PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
        arrayList.add("PBEWITHSHAAND256BITAES-CBC-BC");
        arrayList.add("PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        arrayList.add("PBEWithSHAAnd3KeyTripleDES");
        arrayList.add("PBEWITHSHAAND40BITRC2-CBC");
        arrayList.add("PBEWITHSHAAND40BITRC4");
        arrayList.add("PBEWITHSHAANDIDEA-CBC");
        arrayList.add("PBEWITHSHAANDTWOFISH-CBC");
        return arrayList.toArray(new String[0]);
    }

    public void error(String string) {
        this.print(string, 0);
    }

    public void info(String string) {
        this.print(string, 1);
    }

    private void print(final String string, final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(MainView.getInstance(), string, MainView.this.getString("DEFAULT_MESSAGE_TITLE"), n);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                throw new AssertionError((Object)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AssertionError((Object)invocationTargetException);
            }
        }
    }

    public void setData(MainModel mainModel) {
        this.sourceFileName.setText(mainModel.getSourceFileName());
        this.passwordField1.setText(mainModel.getPassword1());
        this.passwordField2.setText(mainModel.getPassword2());
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.panel.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("org/dyndns/kwitte/smartcrypt/ui/mainview").getString("OUTPUT_BORDER_TITLE")));
        this.outputButton = new JButton();
        this.outputButton.setEnabled(true);
        this.outputButton.setText("select file");
        jPanel4.add((Component)this.outputButton, new GridConstraints(0, 2, 1, 1, 8, 0, 1, 1, null, null, null, 0, false));
        this.outputFileName = new JComboBox();
        this.outputFileName.setEditable(true);
        jPanel4.add((Component)this.outputFileName, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.radioButtonFile = new JRadioButton();
        this.radioButtonFile.setSelected(true);
        this.$$$loadButtonText$$$(this.radioButtonFile, ResourceBundle.getBundle("org/dyndns/kwitte/smartcrypt/ui/mainview").getString("OUTPUT_FILE"));
        jPanel4.add((Component)this.radioButtonFile, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.radioButtonStdout = new JRadioButton();
        this.radioButtonStdout.setEnabled(true);
        this.$$$loadButtonText$$$(this.radioButtonStdout, ResourceBundle.getBundle("org/dyndns/kwitte/smartcrypt/ui/mainview").getString("OUTPUT_STDOUT"));
        jPanel4.add((Component)this.radioButtonStdout, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.inputFilePanel = new JPanel();
        this.inputFilePanel.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        jPanel3.add((Component)this.inputFilePanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.inputFilePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("org/dyndns/kwitte/smartcrypt/ui/mainview").getString("SOURCE_BORDER_TITLE")));
        this.sourceButton = new JButton();
        this.sourceButton.setRequestFocusEnabled(true);
        this.sourceButton.setRolloverEnabled(false);
        this.sourceButton.setText("select file");
        this.inputFilePanel.add((Component)this.sourceButton, new GridConstraints(0, 1, 1, 1, 8, 0, 1, 1, null, null, null, 0, false));
        this.sourceFileName = new JTextField();
        this.sourceFileName.setText("");
        this.inputFilePanel.add((Component)this.sourceFileName, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("org/dyndns/kwitte/smartcrypt/ui/mainview").getString("ALGORITHM_BORDER_TITLE")));
        this.algorithmComboBox = new JComboBox();
        this.algorithmComboBox.setEditable(true);
        jPanel5.add((Component)this.algorithmComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        jPanel6.setFocusable(false);
        jPanel6.setName("");
        this.panel.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("org/dyndns/kwitte/smartcrypt/ui/mainview").getString("PASSPHRASE_BORDER_TITLE")));
        this.passwordField1 = new JPasswordField();
        jPanel6.add((Component)this.passwordField1, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.decryptButton = new JButton();
        this.decryptButton.setEnabled(false);
        this.decryptButton.setRequestFocusEnabled(true);
        this.decryptButton.setRolloverEnabled(false);
        this.decryptButton.setText("decrypt");
        this.decryptButton.setToolTipText("");
        this.panel.add((Component)this.decryptButton, new GridConstraints(3, 0, 1, 1, 0, 0, 3, 0, null, null, null, 0, false));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.panel.add((Component)jPanel7, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("org/dyndns/kwitte/smartcrypt/ui/mainview").getString("PASSPHRASE_BORDER_TITLE_CONFIRM")));
        this.passwordField2 = new JPasswordField();
        jPanel7.add((Component)this.passwordField2, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.panel.add((Component)jPanel8, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.encryptButton = new JButton();
        this.encryptButton.setEnabled(false);
        this.encryptButton.setText("encrypt");
        this.encryptButton.setToolTipText("");
        jPanel8.add((Component)this.encryptButton, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 0, null, null, null, 0, false));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.panel.add((Component)jPanel9, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        jPanel9.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/dyndns/kwitte/smartcrypt/ui/mainview").getString("THREAD_PRIORITY"));
        jPanel10.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        jPanel9.add((Component)jPanel11, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.threadPriority = new JComboBox();
        this.threadPriority.setMaximumRowCount(10);
        jPanel11.add((Component)this.threadPriority, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

