/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.kwitte.smartcrypt.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public final class ConfirmDialog {
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("org/dyndns/kwitte/smartcrypt/ui/confirmdialog");
    private static final Dimension INITIAL_SIZE = new Dimension(400, 350);
    public static final int YES_OPTION = 2727;
    public static final int NO_OPTION = 2728;
    public static final int YES_ALL_OPTION = 2730;
    public static final int NO_ALL_OPTION = 2731;
    public static final int CANCEL_OPTION = 2729;
    private static final String[] BUTTON_LABELS = new String[]{resourceBundle.getString("YES_OPTION"), resourceBundle.getString("NO_OPTION"), resourceBundle.getString("YES_ALL_OPTION"), resourceBundle.getString("NO_ALL_OPTION"), resourceBundle.getString("CANCEL_OPTION")};
    private static final int[] OPTIONS = new int[]{2727, 2728, 2730, 2731, 2729};
    private static final char[] MNEMONICS = new char[]{resourceBundle.getString("YES_OPTION_MNEMONIC").charAt(0), resourceBundle.getString("NO_OPTION_MNEMONIC").charAt(0), resourceBundle.getString("YES_ALL_OPTION_MNEMONIC").charAt(0), resourceBundle.getString("NO_ALL_OPTION_MNEMONIC").charAt(0), resourceBundle.getString("CANCEL_OPTION_MNEMONIC").charAt(0)};
    private static final int DEFAULT_BUTTON = 1;
    private int value;
    private final JDialog dialog;

    public ConfirmDialog(Frame frame, String string, String string2) {
        this.dialog = new JDialog(frame, string2, true);
        JButton[] jButtonArray = this.createButtons();
        this.dialog.getRootPane().setDefaultButton(jButtonArray[1]);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        for (JButton jButton : jButtonArray) {
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(jButton);
            jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        JLabel jLabel = new JLabel(string);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dialog.getContentPane().add((Component)jPanel2, "Center");
        this.dialog.getContentPane().add((Component)jPanel, "Last");
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                assert (ConfirmDialog.this.value == 0);
                ConfirmDialog.this.value = 2729;
            }
        });
        this.dialog.pack();
    }

    private JButton[] createButtons() {
        assert (OPTIONS.length == MNEMONICS.length);
        assert (OPTIONS.length == BUTTON_LABELS.length);
        JButton[] jButtonArray = new JButton[OPTIONS.length];
        for (int i = 0; i < OPTIONS.length; ++i) {
            final String string = BUTTON_LABELS[i];
            final int n = OPTIONS[i];
            char c = MNEMONICS[i];
            assert (string.toLowerCase().indexOf(c) != -1);
            JButton jButton = new JButton(new AbstractAction(){
                {
                    this.putValue("Name", string);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfirmDialog.this.value = n;
                    ConfirmDialog.this.dialog.setVisible(false);
                }
            });
            jButton.setMnemonic(c);
            jButtonArray[i] = jButton;
        }
        return jButtonArray;
    }

    public int showDialog() {
        this.value = 0;
        this.dialog.setVisible(true);
        return this.value;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                System.out.println(new ConfirmDialog(null, "test", "test").showDialog());
                for (int i = 0; i < OPTIONS.length; ++i) {
                    System.out.println(BUTTON_LABELS[i] + " : " + OPTIONS[i]);
                }
                System.exit(0);
            }
        });
    }
}

