/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.kwitte.smartcrypt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.dyndns.kwitte.smartcrypt.EncryptDecrypt;
import org.dyndns.kwitte.smartcrypt.FileManager;

public class FileManagerImpl
extends FileManager {
    private static final int EOF = -1;
    private static final Logger logger = Logger.getLogger("org.dyndns.kwitte.smartcrypt");
    private static final int MAX_PROGRESS = 100;
    private static final int MIN_STEPS = 1;
    private long numFiles;
    private long totalSize;
    private long lastPosition;
    private static final int BUFFERSIZE = 1024;

    public FileManagerImpl() {
    }

    public FileManagerImpl(long l, long l2) {
        this.numFiles = l;
        this.totalSize = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterFile(File file, InputStream inputStream, OutputStream outputStream, Cipher cipher) throws IOException {
        if (file == null || outputStream == null || cipher == null) {
            throw new NullPointerException();
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new CipherInputStream(inputStream, cipher));
        BufferedOutputStream bufferedOutputStream = EncryptDecrypt.cryptToStdOut() ? new BufferedOutputStream(System.out) : new BufferedOutputStream(outputStream);
        logger.log(Level.FINE, "starting file creation");
        long l = this.totalSize == 0L ? file.length() : this.totalSize;
        long l2 = this.totalSize == 0L ? 0L : this.lastPosition;
        long l3 = l / 100L / 1024L + 1L;
        assert (l3 > 0L);
        byte[] byArray = new byte[1024];
        try {
            int n = 0;
            while (n != -1) {
                long l4;
                for (l4 = 0L; l4 < l3 && (n = ((InputStream)bufferedInputStream).read(byArray)) != -1; ++l4) {
                    l2 += (long)n;
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                }
                l4 = 100L * l2 / (l + 1L);
                if (l4 >= 100L) continue;
                this.setChanged();
                this.notifyObservers((int)l4);
            }
        }
        finally {
            this.clearBuffer(byArray);
            this.lastPosition = l2;
            ((OutputStream)bufferedOutputStream).close();
            ((InputStream)bufferedInputStream).close();
        }
    }

    private void clearBuffer(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    public void setTotalSize(long l) {
        this.totalSize = l;
    }
}

