/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.kwitte.smartcrypt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.swing.SwingUtilities;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.dyndns.kwitte.smartcrypt.CipherFactoryImpl;
import org.dyndns.kwitte.smartcrypt.FileManager;
import org.dyndns.kwitte.smartcrypt.FileManagerImpl;
import org.dyndns.kwitte.smartcrypt.Salter;
import org.dyndns.kwitte.smartcrypt.SalterForOldVersions1To2;
import org.dyndns.kwitte.smartcrypt.ui.MainView;
import org.dyndns.kwitte.smartcrypt.ui.controller.DecryptAction;
import org.dyndns.kwitte.smartcrypt.ui.controller.EncryptAction;

public final class EncryptDecrypt {
    private static final String DECRYPT_FLAG = "-d(s)?";
    private static final String DECRYPT_OLD_FLAG = "-decrypt2x(s)?";
    private static final int OPTIONS = 0;
    private static final int INFILE = 1;
    private static final int OUTFILE = 2;
    private static final int PASSWORD = 3;
    private static final int ALGORITHM = 4;
    private static volatile boolean cryptToStdOut;
    private static final ResourceBundle resourceBundle;

    public static boolean cryptToStdOut() {
        return cryptToStdOut;
    }

    private static void usage() {
        System.err.println(resourceBundle.getString("USAGE"));
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        if (stringArray.length == 5 && stringArray[0].matches(DECRYPT_FLAG)) {
            if (stringArray[0].contains("s")) {
                cryptToStdOut = true;
                EncryptDecrypt.main(new String[]{stringArray[1], stringArray[2], stringArray[3], stringArray[4]}, 2, new DecryptAction());
            } else {
                EncryptDecrypt.main(new String[]{stringArray[1], stringArray[2], stringArray[3], stringArray[4]}, 2, new DecryptAction());
            }
        } else if (stringArray.length == 5 && stringArray[0].matches(DECRYPT_OLD_FLAG)) {
            if (stringArray[0].contains("s")) {
                cryptToStdOut = true;
                EncryptDecrypt.main(new String[]{stringArray[1], stringArray[2], stringArray[3], stringArray[4]}, 2, new SalterForOldVersions1To2());
            } else {
                EncryptDecrypt.main(new String[]{stringArray[1], stringArray[2], stringArray[3], stringArray[4]}, 2, new DecryptAction());
            }
        } else if (stringArray.length == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainView.getInstance().setVisible(true);
                }
            });
        } else {
            EncryptDecrypt.main(stringArray, 1, new EncryptAction());
        }
    }

    public static void main(String[] stringArray, int n, Salter salter) {
        if (stringArray.length != 4) {
            EncryptDecrypt.usage();
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        CipherFactoryImpl cipherFactoryImpl = new CipherFactoryImpl();
        FileManagerImpl fileManagerImpl = new FileManagerImpl();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = salter.getSalt(fileInputStream);
            salter.writeHeader(fileOutputStream, byArray);
            Cipher cipher = cipherFactoryImpl.createCipher(string4, string3.toCharArray(), n, byArray);
            ((FileManager)fileManagerImpl).filterFile(new File(string), fileInputStream, fileOutputStream, cipher);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.getLogger("org.dyndns.kwitte.smartcrypt").throwing("EncryptDecrypt", "main", noSuchAlgorithmException);
            System.err.println(resourceBundle.getString("UNSUPPORTED_ALGORITHM") + string4);
            EncryptDecrypt.usage();
        }
        catch (IOException iOException) {
            Logger.getLogger("org.dyndns.kwitte.smartcrypt").throwing("EncryptDecrypt", "main", iOException);
            System.err.println(resourceBundle.getString("IO_ERROR") + iOException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            Logger.getLogger("org.dyndns.kwitte.smartcrypt").throwing("EncryptDecrypt", "main", invalidKeyException);
            System.err.println(resourceBundle.getString("INVALID_PASSPHRASE") + string3 + " - " + string4);
            System.err.println(invalidKeyException.getMessage());
        }
    }

    static {
        resourceBundle = ResourceBundle.getBundle("org/dyndns/kwitte/smartcrypt/console");
    }
}

