/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.kwitte.smartcrypt;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.PBEParameterSpec;
import org.dyndns.kwitte.smartcrypt.CipherFactory;
import org.dyndns.kwitte.smartcrypt.KeyFactoryImpl;

public class CipherFactoryImpl
implements CipherFactory {
    public Cipher createCipher(String string, char[] cArray, int n, byte[] byArray) throws NoSuchAlgorithmException, InvalidKeyException {
        Cipher cipher;
        if (string == null || cArray == null) {
            throw new NullPointerException();
        }
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        KeyFactoryImpl keyFactoryImpl = new KeyFactoryImpl();
        Key key = keyFactoryImpl.createKey(string, cArray);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, 1024);
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("PBE");
        try {
            algorithmParameters.init(pBEParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new AssertionError();
        }
        try {
            cipher = Cipher.getInstance(string);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException(noSuchPaddingException.getMessage());
        }
        try {
            cipher.init(n, key, algorithmParameters);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new AssertionError();
        }
        return cipher;
    }
}

